using System;
using System.Collections.Generic;
using System.Linq;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
    public partial class OUTPAT_PROBLEMLISTDB : DBUtils
    {
        #region Fields
        #endregion

        #region Constructors
        public OUTPAT_PROBLEMLISTDB()
        {
        }
        #endregion

        #region Properties
        #endregion

        #region Methods
        public List<OUTPAT_PROBLEMLIST> GetItemsByReferral(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            List<OUTPAT_PROBLEMLIST> objReturn = null;
            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                     LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                     objReturn = dbContext.usp_OUTPAT_PROBLEMLIST_getitemsByReferral(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID).ToList();
                     LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }
            return objReturn;
        }
        #endregion
    }
}
